﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Admin/Ei8htPOS.Master" AutoEventWireup="true" CodeBehind="SalesReport.aspx.cs" Inherits="AZVIC.Ei8htPOS.WebUI.Admin.Reports.SalesReport" %>
<%@ MasterType VirtualPath="~/Admin/Ei8htPOS.Master" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div class="pageheader">
        <h2>
            <i class="fa fa-cubes"></i> Sales Report
        </h2>
        <div class="breadcrumbs">
            <ol class="breadcrumb">
                <li>You are here</li>
                <li><a href="../Dashboard.aspx">Ei8ht POS</a></li>
                <li><a href="Reports.aspx">Reports</a></li>
                <li class="active">Sales Report</li>
            </ol>
        </div>
    </div>

    <div class="main searchFields">
        <div class="row padTop10">
            <div class="col-md-2 col-xs-12 tSize18 cwhite">
                From Date :

            </div>
            <div class="col-md-4 col-xs-12">
                <asp:TextBox ID="txtFromDate" runat="server" CssClass="datepicker" />

            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-2 col-xs-12 tSize18 cwhite">To Date :</div>
            <div class="col-md-4 col-xs-12">
                <asp:TextBox ID="txtToDate" runat="server" CssClass="datepicker" />
            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-2 col-xs-12 tSize18 cwhite"></div>
            <div class="col-md-4 col-xs-12">
                <asp:Button ID="btnSearch" runat="server" CssClass="btn-lg btn btn-primary loading" Text="Search"
                    OnClick="btnSearch_Click" />
                &nbsp;&nbsp;&nbsp;
                        <asp:Button ID="btnShowAll" runat="server" CssClass="btn-lg btn btn-primary loading" Text="Show All"
                            OnClick="btnShowAll_Click" />
            </div>
        </div>
    </div>

    <section class="tile contentField color">
        <div class="tile-header">
            <h1>Sales Report</h1><div class="pull-right">
                <asp:Button runat="server" ID="btnExport" OnClick="btnExportToExcel" CssClass="btn-lg btn btn-primary" Text="Export" />
            </div>
        </div>
        <div class="tile-body nopadding">

            <div class="responsive-table">
                <asp:GridView runat="server" ID="grdCustomers" AllowPaging="true" PageSize="25"
                    CssClass="table" Width="98%" GridLines="Both" AutoGenerateColumns="false"
                    OnPageIndexChanging="grdCustomers_PageIndexChanging">
                    <Columns>
                        <asp:TemplateField HeaderStyle-Width="20" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center"
                            HeaderText="Sl. No.">
                            <ItemTemplate>
                                <%# Container.DataItemIndex + 1  %>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Center" Width="100px"></HeaderStyle>
                            <ItemStyle HorizontalAlign="Center"></ItemStyle>
                        </asp:TemplateField>
                        <asp:BoundField HeaderText="Order From" DataField="OrderFrom" />
                        <asp:BoundField HeaderText="Order Date" DataField="CreatedDate" DataFormatString="{0:dd/MM/yyyy}" />
                        <asp:BoundField HeaderText="Order No.f" DataField="OrderNumber" />
                        <asp:BoundField HeaderText="Invoice No." DataField="InvoiceNo" />
                        <%--<asp:BoundField HeaderText="First Name" DataField="FirstName" />
                        <asp:BoundField HeaderText="Last Name" DataField="LastName" />
                        <asp:BoundField HeaderText="Email" DataField="Email" />
                        <asp:BoundField HeaderText="Contact No." DataField="BillingMobile" />
                        <asp:BoundField HeaderText="Company" DataField="Company" />--%>
                        <asp:BoundField HeaderText="SubTotal" DataField="SubTotal" DataFormatString="{0:0.00}" />
                        <asp:BoundField HeaderText="Discount" DataField="Discount" DataFormatString="{0:0.00}" />
                        <asp:BoundField HeaderText="Shipping" DataField="Shipping" DataFormatString="{0:0.00}" />
                        <asp:BoundField HeaderText="GST" DataField="GST" DataFormatString="{0:0.00}" />
                        <asp:BoundField HeaderText="Total" DataField="Total" DataFormatString="{0:0.00}" />
                    </Columns>
                    <PagerSettings Mode="NumericFirstLast" Visible="true" NextPageText="" PreviousPageText=""
                        Position="TopAndBottom" />
                    <PagerStyle CssClass="pg" HorizontalAlign="Right" VerticalAlign="Middle" BorderStyle="None"
                        BackColor="#ffffff" />
                    <HeaderStyle CssClass="tbl-header" />
                    <RowStyle CssClass="tbl-row" />
                    <AlternatingRowStyle CssClass="tbl-altrow" />
                    <EmptyDataRowStyle />
                    <EmptyDataTemplate>
                        No Record found
                    </EmptyDataTemplate>
                    <EmptyDataRowStyle VerticalAlign="Middle" HorizontalAlign="Center" />
                </asp:GridView>
            </div>
        </div>
    </section>

    <div class="row Footercenter">
        <center>All right reserved - www.ei8htpos.com &copy; 2015</center>
    </div>


</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ScriptContent" runat="server">
</asp:Content>
